/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures.enemies.touhou;

import core.states.GameState;
import entities.Entity;
import entities.creatures.enemies.MinionEntity;
import entities.missiles.minion.MinionShotEntity;
import java.util.ArrayList;
import strategies.logic.Logic;
import util.Config;

public final class TouhouMinionEntity
extends MinionEntity {
    public TouhouMinionEntity(GameState game, int x, int y, Logic logic) {
        super(game, x, y);
        this.setMoveSpeed(Math.min((Config.get(Config.minionMoveSpeed) + Config.get(Config.minionMoveSpeedPerLevel) * (double)game.getLevel()) * this.getMoveSpeedMultiplier(), (double)Config.get(Config.minionMoveSpeedCap)));
        this.logic = logic;
        logic.setEntity(this);
    }

    @Override
    public void notifyMinionkill() {
    }

    @Override
    public void refreshMoveSpeed() {
        this.moveSpeed = this.normalMoveSpeed * this.getMoveSpeedMultiplier();
    }

    @Override
    public void notifyDeath() {
        ArrayList<Entity> entities = this.game.getEntities();
        int i = 0;
        while (i < entities.size()) {
            Entity entity = entities.get(i);
            if (entity instanceof MinionEntity) {
                ((MinionEntity)entity).notifyMinionkill();
            }
            ++i;
        }
        super.notifyDeath();
    }

    @Override
    public void turnAround() {
    }

    @Override
    protected void shot() {
        if (!this.canShoot) {
            return;
        }
        MinionShotEntity shot = new MinionShotEntity(this, this.game, (int)this.x + this.getW() / 2 - 12, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
    }

    @Override
    protected void abilityQ() {
    }

    @Override
    protected void abilityW() {
    }

    @Override
    protected void abilityE() {
    }

    @Override
    protected void abilityR() {
    }
}

